IF OBJECT_ID('P_EST_PROD_DESCONTOS_APLICAR_VENDAS') IS NOT NULL
BEGIN
	DROP PROCEDURE P_EST_PROD_DESCONTOS_APLICAR_VENDAS
END
GO
--EXEC P_EST_PROD_DESCONTOS_APLICAR_VENDAS 1,26
CREATE PROCEDURE P_EST_PROD_DESCONTOS_APLICAR_VENDAS 
									@CD_EMP_PAR INT=1, 
									@CD_FILIAL_PAR INT,
									@DT_INI DATETIME,
									@DT_FIM DATETIME
AS
SET NOCOUNT ON  
DECLARE @CD_EMP 	INT
DECLARE @CD_FILIAL 	INT
DECLARE @CD_VD 		INT
DECLARE @CD_PROD 	INT
DECLARE @CD_IT 		INT
DECLARE @TX_DESC 	MONEY
DECLARE @QT_IT 		MONEY
DECLARE @CD_CLI 	INT
DECLARE @NR_ECF 	VARCHAR(10)
DECLARE @CD_CX 		INT
DECLARE @MSG 		VARCHAR(max)
CREATE TABLE #RS_RET
        (VERSAO					  VARCHAR(100),
		 CD_EMP                   INT, 
         CD_FILIAL                INT, 
         CD_PROD                  INT, 
         DS_PROD                  VARCHAR(100), 
         NM_FABRIC                VARCHAR(100), 
         VLR_TABELA               MONEY, 
         VLR_OFERTA               MONEY, 
         QTDE_PONTO_FIDEL         MONEY, 
         CTR_PMC                  INT, 
         LIB_DESC_VERBA           INT, 
         FLAG_REQUER_RECEIT       INT, 
         FLAG_ALTERAR_PRECO       INT, 
         PROD_USO_CONT            INT, 
         TP_PROD                  INT, 
         VLR_CUSTO                MONEY, 
         CD_GRP                   INT, 
         QTD_PONTO_VENDA          MONEY, 
         LMT_PROD_PONTO_VENDA     MONEY, 
         APRES_QT_VD              INT, 
         QTDE_ESTOQUE             MONEY, 
         DS_TIPO_RECEITA          VARCHAR(100), 
         DS_COR_RECEITA           VARCHAR(100), 
         PERC_DESC_LIMITE         MONEY, 
         CD_TRIB_FC               VARCHAR(3), 
         PERC_ICMS_N_CONT_ESTA    MONEY, 
         PERC_RED_VD              MONEY, 
         LIBERA_VD_CONV           INT, 
         QTDE_PROD_MAX_CONV       INT, 
         FIXA_DESCONTO            INT, 
         TP_DESCONTO              INT, 
         VLR_ECONOMIA             MONEY, 
         DS_DESCONTO              VARCHAR(150), 
         CD_TBL_DESC              INT, 
         TP_NIVEL                 INT, 
         PERC_DESC                MONEY, 
         MAIOR_PERC_DESC          MONEY, 
         PRODUTO_CONTROLADO       INT,
		 VLR_PMC				  MONEY,
         -- AVALIAR COLUNAS ABAIXO
         FLAG_DESCONTO_TICKET_BLQ INT, 
         PERC_DESC_FIDEL_MAX      MONEY, 
         PROMO_INDUSTRIA          INT, 
         PERC_DESC_ANIVER         MONEY, 
         PERC_DESC_CLAS           MONEY, 
         VLR_DESC_FABRIC          MONEY, 
         CAMPANHA                 INT, 
         QTDE_PROD_CAMPANHA       INT, 
         FLAG_BLOQUEIA_DESCONTO   INT, 
         PERC_DESC_POS_PBM        DECIMAL(6, 4), 
         CD_FAMILIA               INT, 
         NCM_PROD                 VARCHAR(50), 
         NR_REG_MS                VARCHAR(150)
        );

DECLARE PROCPRODUTODESC CURSOR FAST_FORWARD FOR 
SELECT
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_VD,
	PDV_VD.CD_CLI,
	PDV_VD_IT.CD_PROD,
	PDV_VD_IT.CD_IT,
	PDV_VD_IT.QT_IT,
	PDV_VD_IT.TX_DESC,
	PDV_VD.NR_ECF,
	PDV_VD.CD_CX
FROM
	PDV_VD_IT INNER JOIN PDV_VD ON
	PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
WHERE
	PDV_VD_IT.CD_EMP =@CD_EMP_PAR
	AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL_PAR
	AND PDV_VD_IT.TX_DESC > 0
	AND (PDV_VD_IT.CD_TBL_DESC = 0 OR PDV_VD_IT.CD_TBL_DESC IS NULL) 
	AND PDV_VD_IT.DT_VD BETWEEN  @DT_INI AND @DT_FIM
	
OPEN PROCPRODUTODESC;
FETCH NEXT FROM PROCPRODUTODESC INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CLI,
								@CD_PROD,@CD_IT,@QT_IT,@TX_DESC,
								@NR_ECF,@CD_CX;
WHILE @@FETCH_STATUS = 0
    BEGIN
	BEGIN TRY  
		PRINT  'FILIAL.: ' + CONVERT(VARCHAR(10),@CD_FILIAL) + ' CUPOM.: ' + CONVERT(VARCHAR(10),@NR_ECF) + ' CAIXA.: ' + CONVERT(VARCHAR(10),@CD_CX)  + ' PRODUTO.: ' + CONVERT(VARCHAR(10), @CD_PROD)  

		INSERT INTO #RS_RET
		EXEC [P_EST_PROD_DESCONTOS] @CD_EMP, @CD_FILIAL, @CD_PROD, 0, '',0 , @CD_CLI,@QT_IT, 0, 0, 0, 0 ,0
	
	 
	
	
		UPDATE 
			V
        SET
			V.TIPO_DESCONTO=R.TP_DESCONTO,
			V.PERC_DESC_MIN=R.PERC_DESC,
			V.PERC_DESC_MAX=R.MAIOR_PERC_DESC,
			V.CD_TBL_DESC=R.CD_TBL_DESC,
			V.TP_NIVEL=R.TP_NIVEL,
			V.PERC_DESC_DIFF=CASE WHEN  @TX_DESC > R.PERC_DESC THEN
								@TX_DESC-R.PERC_DESC
							 ELSE
								0
							 END
		FROM 
			PDV_VD_IT V INNER JOIN #RS_RET R ON
			V.CD_EMP = R.CD_EMP AND
			V.CD_FILIAL = R.CD_FILIAL AND
			V.CD_PROD = R.CD_PROD 
        WHERE 
			V.CD_EMP=@CD_EMP
			AND V.CD_FILIAL=@CD_FILIAL
			AND V.CD_VD=@CD_VD
			AND V.CD_PROD=@CD_PROD
			AND V.CD_IT=@CD_IT
			AND R.CD_TBL_DESC > 0 

		TRUNCATE TABLE #RS_RET  	
	END TRY 
    BEGIN CATCH 
		SELECT @MSG = ERROR_MESSAGE ()
		PRINT  'Exceção.: ' + CONVERT(VARCHAR(MAX),@MSG)  
	
	END CATCH 
		
		FETCH NEXT FROM PROCPRODUTODESC INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CLI,
										@CD_PROD,@CD_IT,@QT_IT,@TX_DESC,
										@NR_ECF,@CD_CX;
        											
	END;
PRINT 'CONCLUIDO.';
CLOSE PROCPRODUTODESC;
DEALLOCATE PROCPRODUTODESC;

DROP TABLE #RS_RET